// // // // // // // // // // // // // // // //
//
//	Enemy Territory - ZeitWelt.cc
//
//	erstellt 7.2.98 von Andreas Warnke
//	geändert 6.5.98 von Andreas Warnke
//



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "ZeitWelt.h"
#include "Objekt.h"



// // // // // // // // // // // // // // // //
//
//	Konstruktor:
//

ZeitWelt :: ZeitWelt ( unsigned int inMapSize )
	: Welt ( inMapSize )
{
};



// // // // // // // // // // // // // // // //
//
//	Insert:
//

bool ZeitWelt :: Insert ( Objekt * inObjekt )
{
	if ( inObjekt -> BusyTill > real_time_clock_usecs() )
		if ( ! BusyList . Insert ( (Element*) inObjekt ) )
			return false;
	bool ok = Welt :: Insert ( inObjekt );
	if ( ! ok )
		BusyList . Remove ( (Element*) inObjekt );
	return ok;
};



// // // // // // // // // // // // // // // //
//
//	Delete:
//

Objekt * ZeitWelt :: DeleteID ( unsigned int inID, bool real_deletion )
{
	Objekt * Finger = ( Welt :: DeleteID ( inID, real_deletion ) );
	if ( Finger != NULL )
		BusyList . Remove ( (Element*) Finger );
	return Finger;
};



// // // // // // // // // // // // // // // //
//
//	MoveObjectTo:
//

bool ZeitWelt :: MoveObjectTo ( Objekt * inObjekt )
{
	if ( ! BusyList . HasElement ( (Element*) inObjekt ) )
		BusyList . Insert ( (Element*) inObjekt );
	return ( Welt :: MoveObjectTo ( inObjekt ) );
};



//
//	Ende
//
// // // // // // // // // // // // // // // //